<?php

if ( ! function_exists( 'boostup_mikado_sticky_header_global_js_var' ) ) {
	function boostup_mikado_sticky_header_global_js_var( $global_variables ) {
		$global_variables['mkdfStickyHeaderHeight']             = boostup_mikado_get_sticky_header_height();
		$global_variables['mkdfStickyHeaderTransparencyHeight'] = boostup_mikado_get_sticky_header_height_of_complete_transparency();

		return $global_variables;
	}
	
	add_filter( 'boostup_mikado_filter_js_global_variables', 'boostup_mikado_sticky_header_global_js_var' );
}

if ( ! function_exists( 'boostup_mikado_sticky_header_per_page_js_var' ) ) {
	function boostup_mikado_sticky_header_per_page_js_var( $perPageVars ) {
		$perPageVars['mkdfStickyScrollAmount'] = boostup_mikado_get_sticky_scroll_amount();
		
		return $perPageVars;
	}
	
	add_filter( 'boostup_mikado_filter_per_page_js_vars', 'boostup_mikado_sticky_header_per_page_js_var' );
}

if ( ! function_exists( 'boostup_mikado_register_sticky_header_areas' ) ) {
	/**
	 * Registers widget area for sticky header
	 */
	function boostup_mikado_register_sticky_header_areas() {
		register_sidebar(
			array(
				'id'            => 'mkdf-sticky-right',
				'name'          => esc_html__( 'Sticky Header Widget Area', 'boostup' ),
				'description'   => esc_html__( 'Widgets added here will appear on the right hand side from the sticky menu', 'boostup' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s mkdf-sticky-right">',
				'after_widget'  => '</div>'
			)
		);
	}
	
	add_action( 'widgets_init', 'boostup_mikado_register_sticky_header_areas' );
}

if ( ! function_exists( 'boostup_mikado_get_sticky_menu' ) ) {
	/**
	 * Loads sticky menu HTML
	 *
	 * @param string $additional_class addition class to pass to template
	 */
	function boostup_mikado_get_sticky_menu( $additional_class = 'mkdf-default-nav' ) {
		boostup_mikado_get_module_template_part( 'templates/sticky-navigation', 'header/types/sticky-header', '', array( 'additional_class' => $additional_class ) );
	}
}

if ( ! function_exists( 'boostup_mikado_get_sticky_header' ) ) {
	/**
	 * Loads sticky header behavior HTML
	 */
	function boostup_mikado_get_sticky_header( $slug = '', $module = '' ) {
        $page_id             = boostup_mikado_get_page_id();
		$sticky_in_grid      = boostup_mikado_options()->getOptionValue( 'sticky_header_in_grid' ) == 'yes' ? true : false;
		$header_in_grid_meta = get_post_meta( $page_id, 'mkdf_menu_area_in_grid_meta', true);
		$menu_area_position  = boostup_mikado_get_meta_field_intersect( 'set_menu_area_position', $page_id );
		
		if ( $header_in_grid_meta === 'yes' && ! $sticky_in_grid ) {
			$sticky_in_grid = true;
		} else if ( $header_in_grid_meta === 'no' && $sticky_in_grid ) {
			$sticky_in_grid = false;
		}
		
		$parameters = array(
			'hide_logo'                  => boostup_mikado_options()->getOptionValue( 'hide_logo' ) == 'yes' ? true : false,
			'sticky_header_in_grid'      => $sticky_in_grid,
			'fullscreen_menu_icon_class' => boostup_mikado_get_fullscreen_menu_icon_class(),
            'menu_area_position'    	 => $menu_area_position,
			'menu_area_class'       	 => ! empty( $menu_area_position ) ? 'mkdf-menu-' . $menu_area_position : ''
		);
		
		$module = ! empty( $module ) ? $module : 'header/types/sticky-header';
		
		boostup_mikado_get_module_template_part( 'templates/sticky-header', $module, $slug, $parameters );
	}
}

if ( ! function_exists( 'boostup_mikado_get_sticky_header_widget_menu_area' ) ) {
	/**
	 * Loads sticky header widgets area HTML
	 */
	function boostup_mikado_get_sticky_header_widget_menu_area() {
		$page_id                 = boostup_mikado_get_page_id();
		$custom_menu_widget_area = get_post_meta( $page_id, 'mkdf_custom_sticky_menu_area_sidebar_meta', true );
		
		if ( is_active_sidebar( 'mkdf-sticky-right' ) && empty( $custom_menu_widget_area ) ) {
			dynamic_sidebar( 'mkdf-sticky-right' );
		} else if ( ! empty( $custom_menu_widget_area ) && is_active_sidebar( $custom_menu_widget_area ) ) {
			dynamic_sidebar( $custom_menu_widget_area );
		}
	}
}

if ( ! function_exists( 'boostup_mikado_get_sticky_header_height' ) ) {
	/**
	 * Returns top sticky header height
	 *
	 * @return bool|int|void
	 */
	function boostup_mikado_get_sticky_header_height() {
		$allow_sticky_behavior = true;
		$allow_sticky_behavior = apply_filters( 'boostup_mikado_filter_allow_sticky_header_behavior', $allow_sticky_behavior );
		$header_behaviour      = boostup_mikado_get_meta_field_intersect( 'header_behaviour' );
		
		//sticky menu height, needed only for sticky header on scroll up
		if ( $allow_sticky_behavior && in_array( $header_behaviour, array( 'sticky-header-on-scroll-up', 'sticky-header-on-scroll-down-up' ) ) ) {
			$sticky_header_height = boostup_mikado_filter_px( boostup_mikado_options()->getOptionValue( 'sticky_header_height' ) );
			
			return $sticky_header_height !== '' ? intval( $sticky_header_height ) : 70;
		} else {
			return 0;
		}
	}
}

if ( ! function_exists( 'boostup_mikado_get_sticky_header_height_of_complete_transparency' ) ) {
	/**
	 * Returns top sticky header height it is fully transparent. used in anchor logic
	 *
	 * @return bool|int|void
	 */
	function boostup_mikado_get_sticky_header_height_of_complete_transparency() {
		$allow_sticky_behavior = true;
		$allow_sticky_behavior = apply_filters( 'boostup_mikado_filter_allow_sticky_header_behavior', $allow_sticky_behavior );
		
		if ( $allow_sticky_behavior ) {
			$stickyHeaderTransparent = boostup_mikado_options()->getOptionValue( 'sticky_header_background_color' ) !== '' && boostup_mikado_options()->getOptionValue( 'sticky_header_transparency' ) === '0';
			
			if ( $stickyHeaderTransparent ) {
				return 0;
			} else {
				$sticky_header_height = boostup_mikado_filter_px( boostup_mikado_options()->getOptionValue( 'sticky_header_height' ) );
				
				return $sticky_header_height !== '' ? intval( $sticky_header_height ) : 70;
			}
		} else {
			return 0;
		}
	}
}

if ( ! function_exists( 'boostup_mikado_get_sticky_scroll_amount' ) ) {
	/**
	 * Returns top sticky scroll amount
	 *
	 * @return bool|int|void
	 */
	function boostup_mikado_get_sticky_scroll_amount() {
		$allow_sticky_behavior = true;
		$allow_sticky_behavior = apply_filters( 'boostup_mikado_filter_allow_sticky_header_behavior', $allow_sticky_behavior );
		$header_behaviour      = boostup_mikado_get_meta_field_intersect( 'header_behaviour' );
		
		//sticky menu scroll amount
		if ( $allow_sticky_behavior && in_array( $header_behaviour, array( 'sticky-header-on-scroll-up', 'sticky-header-on-scroll-down-up' ) ) ) {
			$sticky_scroll_amount = boostup_mikado_filter_px( boostup_mikado_get_meta_field_intersect( 'scroll_amount_for_sticky' ) );
			
			return $sticky_scroll_amount !== '' ? intval( $sticky_scroll_amount ) : 0;
		} else {
			return 0;
		}
	}
}

if ( ! function_exists( 'boostup_mikado_get_fullscreen_menu_icon_class' ) ) {
    /**
     * Loads full screen menu icon class
     */
    function boostup_mikado_get_fullscreen_menu_icon_class() {
        $classes = array(
            'mkdf-fullscreen-menu-opener'
        );

        $classes[] = boostup_mikado_get_icon_sources_class( 'fullscreen_menu', 'mkdf-fullscreen-menu-opener' );

        return $classes;
    }
}

if ( ! function_exists( 'boostup_mikado_sticky_header_area_style' ) ) {
    /**
     * Function that return styles for header area
     */
    function boostup_mikado_sticky_header_area_style( $style ) {
        $page_id      = boostup_mikado_get_page_id();
        $class_prefix = boostup_mikado_get_unique_page_class( $page_id, true );

        $current_style = '';
        $sticky_background_style         = array();
        $sticky_menu_item_style         = array();
        $sticky_menu_active_and_hover_item_style         = array();

        /* sticky background start */

        $sticky_background_color        = get_post_meta( $page_id, 'mkdf_sticky_area_background_color_meta', true );
        $sticky_background_transparency = get_post_meta( $page_id, 'mkdf_sticky_area_background_transparency_meta', true );


        if ( $sticky_background_transparency === '' ) {
            $sticky_background_transparency = 1;
        }
        $sticky_background_color_rgba = boostup_mikado_rgba_color( $sticky_background_color, $sticky_background_transparency );

        if ( ! empty( $sticky_background_color_rgba ) ) {
            $sticky_background_style['background-color'] = $sticky_background_color_rgba;
        }

        $sticky_container_selector = array(
            $class_prefix . ' .mkdf-sticky-header .mkdf-sticky-holder'
        );

        $current_style .= boostup_mikado_dynamic_css( $sticky_container_selector, $sticky_background_style );

        /* sticky background end */

        /* sticky item start */

        $sticky_menu_item_color                           = get_post_meta( $page_id, 'mkdf_sticky_area_menu_item_color', true );
        $sticky_menu_active_and_hover_item_color          = get_post_meta( $page_id, 'mkdf_sticky_area_menu_active_and_hover_item_color', true );

        if ( ! empty( $sticky_menu_item_color ) ) {
            $sticky_menu_item_style['color'] = $sticky_menu_item_color;
        }
        if ( ! empty( $sticky_menu_active_and_hover_item_color ) ) {
            $sticky_menu_active_and_hover_item_style['color'] = $sticky_menu_active_and_hover_item_color;
        }

        $sticky_menu_selector = array(
            $class_prefix . ' .mkdf-main-menu>ul>li>a'
        );
        $sticky_active_menu_selector = array(
            $class_prefix . ' .mkdf-main-menu>ul>li.mkdf-active-item>a'
        );
        $sticky_hover_menu_selector = array(
            $class_prefix . ' .mkdf-main-menu ul li a:hover'
        );

        $current_style .= boostup_mikado_dynamic_css( $sticky_menu_selector, $sticky_menu_item_style );
        $current_style = $style . $current_style;

        $current_style .= boostup_mikado_dynamic_css( $sticky_active_menu_selector, $sticky_menu_active_and_hover_item_style );
        $current_style = $style . $current_style;

        $current_style .= boostup_mikado_dynamic_css( $sticky_hover_menu_selector, $sticky_menu_active_and_hover_item_style );
        $current_style = $style . $current_style;

        /* sticky item end */



        return $current_style;
    }

    add_filter( 'boostup_mikado_filter_add_page_custom_style', 'boostup_mikado_sticky_header_area_style' );
}