<?php

if ( ! function_exists( 'boostup_mikado_map_post_audio_meta' ) ) {
	function boostup_mikado_map_post_audio_meta() {
		$audio_post_format_meta_box = boostup_mikado_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Audio Post Format', 'boostup' ),
				'name'  => 'post_format_audio_meta'
			)
		);
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_audio_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Audio Type', 'boostup' ),
				'description'   => esc_html__( 'Choose audio type', 'boostup' ),
				'parent'        => $audio_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Audio Service', 'boostup' ),
					'self'            => esc_html__( 'Self Hosted', 'boostup' )
				)
			)
		);
		
		$mkdf_audio_embedded_container = boostup_mikado_add_admin_container(
			array(
				'parent' => $audio_post_format_meta_box,
				'name'   => 'mkdf_audio_embedded_container'
			)
		);
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_audio_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio URL', 'boostup' ),
				'description' => esc_html__( 'Enter audio URL', 'boostup' ),
				'parent'      => $mkdf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_audio_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_audio_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio Link', 'boostup' ),
				'description' => esc_html__( 'Enter audio link', 'boostup' ),
				'parent'      => $mkdf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_audio_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'boostup_mikado_action_meta_boxes_map', 'boostup_mikado_map_post_audio_meta', 23 );
}